/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.components.PlaybackProgressBar;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImageNameBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.loadertypes.IMPMusicLoaderTypes;
import dev.felnull.imp.client.music.loadertypes.IMusicLoaderType;
import dev.felnull.imp.client.music.player.IMusicPlayer;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MusicBaseMMMonitor
extends ImageNameBaseMMMonitor {
    private static final class_2960 ADD_MUSIC_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/music_manager/monitor/add_music.png");
    private static final class_2960 SHOW_MUSIC_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/music_manager/monitor/show_music.png");
    private static final class_2561 PLAYBACK_CONTROL_TEXT = new class_2588("imp.button.playbackControl");
    protected static final class_2561 MUSIC_SOURCE_TEXT = new class_2588("imp.text.musicSource");
    private static final class_2561 PLAYBACK_NON_PROGRESS_TEXT = new class_2585("--:--/--:--");
    private static final class_2561 PLAYBACK_LOADING_PROGRESS_TEXT = new class_2588("imp.text.playbackLoading");
    private SmartButton playControlButton;
    protected int playBackX = 189;
    protected int playBackY = 40;
    protected boolean isLoaderSelect;
    private class_2561 AUTHOR_TEXT;

    public MusicBaseMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.playControlButton = this.addRenderWidget(new SmartButton(this.getStartX() + this.playBackX, this.getStartY() + this.playBackY, 20, 20, PLAYBACK_CONTROL_TEXT, n -> {
            if (this.getScreen().isMusicPlaying()) {
                this.getScreen().stopMusic();
            } else if (!this.getMusicSource().isEmpty()) {
                this.getScreen().playMusic(this.getMusicSource(), 0L);
            }
        }));
        this.playControlButton.setHideText(true);
        this.playControlButton.setIcon(WIDGETS_TEXTURE, 0, 123, 11, 11);
        this.playControlButton.field_22763 = !this.getMusicSource().isEmpty();
        this.addRenderWidget(new PlaybackProgressBar(this.getStartX() + this.playBackX + 22, this.getStartY() + this.playBackY + 14, (class_2561)new class_2588("imp.progressBar.playbackControl"), () -> {
            if (this.getScreen().isMusicPlaying()) {
                return Float.valueOf(this.getScreen().getMusicPlayer().getPositionProgress());
            }
            return Float.valueOf(0.0f);
        }, n -> {
            if (this.getScreen().isMusicPlaying()) {
                MusicSource ms = this.getScreen().getMusicPlayer().getMusicSource();
                this.getScreen().playMusic(ms, (long)((float)ms.getDuration() * n.floatValue()));
            }
        }));
        if (!this.getMusicAuthor().isEmpty()) {
            this.setMusicAuthor(this.getMusicAuthor());
        }
    }

    @Override
    public void depose() {
        super.depose();
        this.AUTHOR_TEXT = null;
    }

    @Override
    public void tick() {
        super.tick();
        boolean bl = this.playControlButton.field_22763 = !this.getMusicSource().isEmpty();
        if (this.getScreen().isMusicPlaying() || this.getScreen().isMusicLoading()) {
            this.playControlButton.setIcon(WIDGETS_TEXTURE, 0, 134, 11, 11);
        } else {
            this.playControlButton.setIcon(WIDGETS_TEXTURE, 0, 123, 11, 11);
        }
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        Object pt;
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtil.drawTexture((class_2960)(this.isLoaderSelect ? ADD_MUSIC_TEXTURE : SHOW_MUSIC_TEXTURE), (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        this.drawSmartText(poseStack, MUSIC_SOURCE_TEXT, this.getStartX() + 189, this.getStartY() + 13);
        OERenderUtil.drawTexture((class_2960)MusicManagerMonitor.WIDGETS_TEXTURE, (class_4587)poseStack, (float)(this.getStartX() + this.playBackX), (float)(this.getStartY() + this.playBackY), (float)68.0f, (float)90.0f, (float)177.0f, (float)20.0f);
        if (this.getScreen().isMusicPlaying()) {
            IMusicPlayer mp = this.getScreen().getMusicPlayer();
            pt = new class_2585(FNStringUtil.getTimeProgress(mp.getPosition(), mp.getMusicSource().getDuration()));
        } else {
            pt = this.getScreen().isMusicLoading() ? PLAYBACK_LOADING_PROGRESS_TEXT : (!this.getMusicSource().isEmpty() ? new class_2585(FNStringUtil.getTimeProgress(0L, this.getMusicSource().getDuration())) : PLAYBACK_NON_PROGRESS_TEXT);
        }
        this.drawSmartText(poseStack, (class_2561)pt, this.getStartX() + this.playBackX + 22, this.getStartY() + this.playBackY + 4);
        if (this.AUTHOR_TEXT != null) {
            this.drawSmartText(poseStack, this.AUTHOR_TEXT, this.getStartX() + this.playBackX, this.getStartY() + this.playBackY + 25);
        }
        if (!this.isLoaderSelect) {
            this.drawSmartButtonBox(poseStack, this.getStartX() + 189, this.getStartY() + 22, 176, 15, false);
            IMusicLoaderType lt = this.getRawMusicLoaderType();
            if (lt != null) {
                int sx = 0;
                class_2960 ic = lt.getIcon();
                if (ic != null) {
                    OERenderUtil.drawTexture((class_2960)ic, (class_4587)poseStack, (float)(this.getStartX() + 190), (float)(this.getStartY() + 23), (float)0.0f, (float)0.0f, (float)13.0f, (float)13.0f, (float)13.0f, (float)13.0f);
                    sx += 13;
                }
                this.drawSmartText(poseStack, lt.getName(), this.getStartX() + 190 + sx + 2, (float)this.getStartY() + 21.0f + 4.25f);
            }
        }
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        OERenderUtil.renderTextureSprite((class_2960)(this.isLoaderSelect ? ADD_MUSIC_TEXTURE : SHOW_MUSIC_TEXTURE), (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        this.renderSmartTextSprite(poseStack, multiBufferSource, MUSIC_SOURCE_TEXT, 189.0f, 13.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
        this.renderTextureSprite(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, multiBufferSource, this.playBackX, this.playBackY, 0.003f, 177.0f, 20.0f, 68.0f, 90.0f, 177.0f, 20.0f, 256.0f, 256.0f, i, j, onPxW, onPxH, monitorHeight);
        Object pt = !this.getMusicSource(blockEntity).isEmpty() ? new class_2585(FNStringUtil.getTimeProgress(0L, this.getMusicSource(blockEntity).getDuration())) : PLAYBACK_NON_PROGRESS_TEXT;
        this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)pt, this.playBackX + 22, this.playBackY + 4, 0.004f, onPxW, onPxH, monitorHeight, i);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, this.playBackX, this.playBackY, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, WIDGETS_TEXTURE, 0, 123, 11, 11, 256, 256, this.getMusicSource(blockEntity).isEmpty());
        OERenderUtil.renderTextureSprite((class_2960)WIDGETS_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)(onPxW * (float)(this.playBackX + 22)), (float)(monitorHeight - onPxH * (float)(this.playBackY + 14 + 3)), (float)0.004f, (float)0.0f, (float)0.0f, (float)0.0f, (float)(onPxW * 153.0f), (float)(onPxH * 3.0f), (float)52.0f, (float)54.0f, (float)153.0f, (float)3.0f, (float)256.0f, (float)256.0f, (int)i, (int)j);
        if (!this.getMusicAuthor(blockEntity).isEmpty()) {
            int le = 176 - MusicBaseMMMonitor.mc.field_1772.method_27525((class_5348)new class_2588("imp.text.musicAuthor", new Object[]{""}));
            String aut = OERenderUtil.getWidthString((String)this.getMusicAuthor(blockEntity), (float)le, (String)"...");
            this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)new class_2588("imp.text.musicAuthor", new Object[]{aut}), this.playBackX, this.playBackY + 25, 0.004f, onPxW, onPxH, monitorHeight, i);
        }
        if (!this.isLoaderSelect) {
            this.renderSmartButtonBoxSprite(poseStack, multiBufferSource, 189.0f, 22.0f, 0.003f, 176.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight);
            IMusicLoaderType lt = this.getRawMusicLoaderType(blockEntity);
            if (lt != null) {
                int sx = 0;
                class_2960 ic = lt.getIcon();
                if (ic != null) {
                    this.renderTextureSprite(ic, poseStack, multiBufferSource, 190.0f, 23.0f, 0.0050000004f, 13.0f, 13.0f, 0.0f, 0.0f, 13.0f, 13.0f, 13.0f, 13.0f, i, j, onPxW, onPxH, monitorHeight);
                    sx += 13;
                }
                this.renderSmartTextSprite(poseStack, multiBufferSource, lt.getName(), 190 + sx + 2, 27.25f, 0.0050000004f, onPxW, onPxH, monitorHeight, i);
            }
        }
    }

    protected void setMusicAuthor(String author) {
        if (author.isEmpty()) {
            this.AUTHOR_TEXT = null;
        } else {
            int le = 176 - MusicBaseMMMonitor.mc.field_1772.method_27525((class_5348)new class_2588("imp.text.musicAuthor", new Object[]{""}));
            String aut = OERenderUtil.getWidthString((String)author, (float)le, (String)"...");
            this.AUTHOR_TEXT = new class_2588("imp.text.musicAuthor", new Object[]{aut});
        }
    }

    @NotNull
    protected String getMusicAuthor() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)class_25862;
            return this.getMusicAuthor(musicManagerBlock);
        }
        return "";
    }

    @NotNull
    protected String getMusicAuthor(@NotNull MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getMyMusicAuthor();
    }

    @NotNull
    protected String getMusicSourceName() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity blockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getMusicSourceName(blockEntity);
        }
        return "";
    }

    @NotNull
    protected String getMusicSourceName(@NotNull MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMyMusicSourceName();
    }

    @NotNull
    protected MusicSource getMusicSource() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity blockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getMusicSource(blockEntity);
        }
        return MusicSource.EMPTY;
    }

    @NotNull
    protected MusicSource getMusicSource(@NotNull MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMyMusicSource();
    }

    @Nullable
    protected IMusicLoaderType getRawMusicLoaderType(@NotNull MusicManagerBlockEntity musicManagerBlockEntity) {
        return IMPMusicLoaderTypes.getMusicLoaderTypes().get(this.getMusicLoaderType(musicManagerBlockEntity));
    }

    @Nullable
    protected IMusicLoaderType getRawMusicLoaderType() {
        return IMPMusicLoaderTypes.getMusicLoaderTypes().get(this.getMusicLoaderType());
    }

    @NotNull
    protected String getMusicLoaderType() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity blockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getMusicLoaderType(blockEntity);
        }
        return "auto";
    }

    @NotNull
    protected String getMusicLoaderType(@NotNull MusicManagerBlockEntity blockEntity) {
        return blockEntity.getMyMusicLoaderType().isEmpty() ? "auto" : blockEntity.getMyMusicLoaderType();
    }
}

